<?php
try{
    $dsn = 'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset='.DB_CHARSET;
    $db = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_PERSISTENT => true, // Enable persistent connections
        PDO::ATTR_TIMEOUT => 30, // Set statement timeout
        PDO::ATTR_EMULATE_PREPARES => false // Use real prepared statements
    ]);
    
    // Set connection timeout
    $db->setAttribute(PDO::ATTR_TIMEOUT, 30);
    
    // Enable query cache only for older MySQL versions that support it
    // Note: query_cache_type was removed in MySQL 8.0+
    try {
        $db->exec("SET SESSION query_cache_type = ON");
    } catch (Exception $e) {
        // Ignore if query cache is not supported
        error_log("Query cache not supported: " . $e->getMessage());
    }
} catch(Exception $e){
    error_log('DB connection error: ' . $e->getMessage());
    die('DB connection error: ' . htmlspecialchars($e->getMessage()));
}

function slugify($text){
    $text = preg_replace('~[\s\t\r\n]+~u', '-', trim($text));
    $text = mb_strtolower($text, 'UTF-8');
    $text = preg_replace('~[^a-z0-9\-\_]+~u', '-', $text);
    $text = trim($text, '-');
    if($text === '') $text = 'item-' . time();
    return $text;
}